﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   スレッド関連の型の宣言（private）
 */

#pragma once

#include <nn/os/os_Config.h>
#include <nn/nn_Common.h>

#if defined(NN_BUILD_CONFIG_OS_WIN32)
    #include "detail/os_ThreadTypes-os.win32.private.h"
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
    #include "detail/os_ThreadTypes-os.horizon.private.h"
#endif


namespace nn { namespace os {

//-----------------------------------------------------------------------------

#if defined( NN_BUILD_FOR_DOCUMENT_GENERATION )
//-----------------------------------------------------------------------------
/**
 * @brief   スレッドコンテキスト情報を格納する構造体です。
 *
 * @details
 *  この構造体は各ターゲット環境に合わせて、以下の表に示すように別途定義
 *  されている別名の構造体から typedef されています。@n
 *  詳細はリンク先にある各構造体の定義を参照して下さい。
 *
 *  |ターゲット環境個別の構造体名|説明|
 *  |:-----:|:----|
 *  |nn::os::ThreadContextInfoAarch32|AArch32 動作環境の場合|
 *  |nn::os::ThreadContextInfoAarch64|AArch64 動作環境の場合|
 *  |nn::os::ThreadContextInfoWin|Windows 環境の場合|
 *
 *  NX32 および NX64 環境ではどちらも
 *  nn::os::ThreadContextInfoAarch64 の構造体が使用されます。
 *
 *  Win32 および x64 環境では、この構造体を使用せずに、
 *  winnt.h で定義されている CONTEXT 構造体をそのまま利用して下さい。
 *
 */
struct ThreadContextInfo
{
};
#endif


//-----------------------------------------------------------------------------

}} // namespace nn::os

