﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief  SDK 専用のスレッドローカルストレージに関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_Result.h>
#include <nn/os/os_ThreadLocalStorageCommon.h>

namespace nn { namespace os {

//! @name スレッド固有領域関連 API
//! @{

//--------------------------------------------------------------------------
/**
 * @brief   SDK 内部用の空き TLS スロットを確保します。
 *
 * @param[out] outTlsSlot   獲得した TLS スロット番号の格納先
 * @param[in]  function     デストラクタ用コールバック関数エントリ
 *
 * @retresult
 *   @handleresult{nn::os::ResultOutOfResource}
 * @endretresult
 *
 * @pre
 *  - SDK 内部の API から呼び出している
 *
 * @post
 *  - SDK 内部用の TLS の空きスロットを確保し、そのスロット番号を outTlsSlot に格納する
 *  - 確保した TLS スロットの TLS 初期値を 0 にする（全スレッド）
 *  - function が非 NULL の場合、TLS デストラクタ関数を登録する
 *
 * @details
 *  SDK 内部用の TLS スロットを確保します。
 *
 *  本 API を使って確保できる TLS スロットは SDK 専用のものであり、
 *  アプリケーション用の AllocateTlsSlot() の TLS スロットは消費しません。
 *
 *  その他の詳細は AllocateTlsSlot() と同様のため、そちらの API リファレンスを
 *  参照して下さい。
 *
 */
nn::Result  SdkAllocateTlsSlot(TlsSlot* outTlsSlot, TlsDestructor function)    NN_NOEXCEPT;

//! @}

//--------------------------------------------------------------------------

}} // namespace nn::os

