﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   SDK 専用の多重待ちに関する API の宣言
 * @details 本ヘッダファイルはリリースパッケージには含まれません
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_NativeHandleTypes.h>

//--------------------------------------------------------------------------
//  C++ 向けの宣言
//--------------------------------------------------------------------------

namespace nn { namespace os {

struct  MultiWaitHolderType;

//! @name 多重待ち関連 API
//! @{

//--------------------------------------------------------------------------
/**
 * @brief   multiWaitHolder を初期化し、 NativeHandle と関連付けます。
 *
 * @overloadlist{nn_os_InitializeMultiWaitHolder}
 *
 * @param[in] multiWaitHolder   多重待ちホルダーへのポインタ
 * @param[in] handle            関連付けるハンドル
 *
 * @pre
 *  - multiWaitHolder が未初期化状態である
 *  - handle が有効である
 *
 * @post
 *  - multiWaitHolder が初期化状態である（handle に関連付けられる）
 *  - @ref nn::os::GetMultiWaitHolderUserData "nn::os::GetMultiWaitHolderUserData(multiWaitHolder)" == 0
 *
 * @details
 *  multiWaitHolder を初期化し、カーネルの handle と関連付けます。
 *
 *  関連付けされた multiWaitHolder は、対象 handle のシグナル状態に連動して
 *  WaitAny() などの多重待ち API で起床する要因とすることが出来ます。
 *
 *  本 API によって初期化された multiWaitHolder オブジェクトを使って多重待ちを
 *  行ない、実際に対象のハンドルがシグナル状態になることで多重待ちが解除された
 *  場合でも、対象ハンドルを非シグナル状態に変化させることはありません。@n
 *  詳細は @ref PageNotificationOsMultiWait_AboutWakeup を参照して下さい。
 *
 *  本 API の動作中に対象 multiWaitHolder に対する操作は行なわないで下さい。
 *
 *  本 API は SDK 開発者専用です。@n
 *  具体的には ServiceFramework 開発者のみが利用することを想定しています。@n
 *  本 API のプロトタイプ宣言はリリースパッケージには含まれません。
 *
 */
void    InitializeMultiWaitHolder(MultiWaitHolderType* multiWaitHolder, NativeHandle handle) NN_NOEXCEPT;

//! @}

}} // namespace nn::os

