﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   スレッド関連の型に関する Windows 環境用の型の宣言
 */

#pragma once

#include <nn/nn_Windows.h>
#include <nn/os/os_Config.h>

#include <nn/nn_Common.h>
#include <nn/os/os_Macro.h>


namespace nn { namespace os {

//-----------------------------------------------------------------------------

typedef CONTEXT ThreadContextInfoWin;

//-----------------------------------------------------------------------------
/**
 * @brief   Windows 環境におけるスレッドコンテキスト情報を格納する構造体です。
 *
 * @details
 *  この構造体は CONTEXT 構造体の typedef です。
 *
 *  構造体の内部にアクセスする場合には、winnt.h で定義されている
 *  CONTEXT 構造体にキャストして使用して下さい。
 *
 */
typedef ThreadContextInfoWin    ThreadContextInfo;


//-----------------------------------------------------------------------------

}} // namespace nn::os

