﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_DataId.h>
#include <nn/ncm/ncm_ProgramId.h>

namespace nn { namespace ncm {

    struct SystemProgramId
    {
        Bit64 value;

        static SystemProgramId GetInvalidId() NN_NOEXCEPT
        {
            SystemProgramId id = { nn::ncm::ProgramId::GetInvalidId().value };
            return id;
        }

        NN_IMPLICIT operator ProgramId() const NN_NOEXCEPT
        {
            ProgramId id = { value };
            return id;
        }
    };

    struct SystemDataId
    {
        Bit64 value;

        NN_IMPLICIT operator DataId() const NN_NOEXCEPT
        {
            DataId id = { value };
            return id;
        }
    };

    struct SystemUpdateId
    {
        Bit64 value;

        NN_IMPLICIT operator DataId() const NN_NOEXCEPT
        {
            DataId id = { value };
            return id;
        }
    };

    struct SystemAppletId
    {
        Bit64 value;
    };

    struct LibraryAppletId
    {
        Bit64 value;
    };

    struct SystemApplicationId
    {
        Bit64 value;
    };
}}
