﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ncm/ncm_ContentMetaId.h>

namespace nn { namespace ncm {

class StorageList
{
public:
    static const int MaxCount = 10;
    StorageList() NN_NOEXCEPT : m_Count() {}

    void Push(StorageId storageId) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS(m_Count < MaxCount);

        for (int i = 0; i < m_Count; i++)
        {
            if (m_Array[i] == storageId)
            {
                return;
            }
        }

        m_Array[m_Count] = storageId;
        m_Count++;
    }

    int Count() const NN_NOEXCEPT
    {
        return m_Count;
    }

    StorageId operator[] (int i) const NN_NOEXCEPT
    {
        NN_ABORT_UNLESS(i < m_Count);

        return m_Array[i];
    }

private:
    StorageId m_Array[MaxCount];
    int m_Count;
};

StorageList GetStorageList(StorageId storage) NN_NOEXCEPT;
Result SelectDownloadableStorage(StorageId* outValue, StorageId storageId, int64_t requiredSize) NN_NOEXCEPT;

// パッチの場合に優先してインストールすべきストレージを取得する
// 特に優先するべきものが無い場合は、引数で指定した storageId がそのまま返る
Result SelectPatchStorage(StorageId* outValue, StorageId storageId, PatchId id) NN_NOEXCEPT;

const char* GetStorageIdString(StorageId storageId) NN_NOEXCEPT;
// PlayReport 互換用
const char* GetStorageIdStringForPlayReport(StorageId storageId) NN_NOEXCEPT;


}}
