﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentId.h>
#include <nn/ncm/ncm_ContentType.h>

namespace nn { namespace ncm {
    static const int MaxContentInfoCount = 128;

    struct ContentInfo
    {
        ContentId   id;
        uint32_t    sizeLow;
        uint16_t    sizeHigh;
        ContentType type;
        uint8_t     idOffset;

        const ContentId& GetId() const NN_NOEXCEPT
        {
            return id;
        }

        int64_t GetSize() const NN_NOEXCEPT
        {
            return (static_cast<int64_t>(sizeHigh) << 32) + sizeLow;
        }

        static ContentInfo Make(ContentId id, int64_t size, ContentType type, uint8_t idOffset) NN_NOEXCEPT
        {
            uint32_t sizeLow = size & 0xFFFFFFFFLL;
            uint16_t sizeHigh = static_cast<uint16_t>(size >> 32);

            ContentInfo info = { id, sizeLow, sizeHigh, type, idOffset };
            return info;
        }

        ContentType GetType() const NN_NOEXCEPT
        {
            return type;
        }

        uint8_t GetIdOffset() const NN_NOEXCEPT
        {
            return idOffset;
        }
    };
}}
