﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_RightsId.h>
#include <nn/ncm/ncm_ContentId.h>
#include <nn/ncm/ncm_ContentInfoData.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace ncm {

    const size_t ContentIdStringLength = sizeof(ContentId) * 2;
    const size_t RightsIdStringLength = sizeof(nn::fs::RightsId) * 2;
    const size_t TicketFileStringLength = sizeof(nn::fs::RightsId) * 2 + 4; // .tik
    const size_t CertFileStringLength = sizeof(nn::fs::RightsId) * 2 + 5;   // .cert

    struct ContentIdString
    {
        char data[ContentIdStringLength + 1];
    };

    ContentIdString GetContentIdString(ContentId id) NN_NOEXCEPT;

    void GetStringFromContentId(char* outValue, size_t length, ContentId id) NN_NOEXCEPT;
    void GetStringFromRightsId(char* outValue, size_t length, nn::fs::RightsId id) NN_NOEXCEPT;

    void GetTicketFileStringFromRightsId(char* outValue, size_t length, nn::fs::RightsId id) NN_NOEXCEPT;
    void GetCertificateFileStringFromRightsId(char* outValue, size_t length, nn::fs::RightsId id) NN_NOEXCEPT;

    util::optional<ContentId> GetContentIdFromString(const char* string, size_t length) NN_NOEXCEPT;

    util::optional<Hash> GetHashFromString(const char* string, size_t length) NN_NOEXCEPT;
}}
