﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ncm {

    /**
    * @brief コンテンツ ID です。
    */
    struct ContentId
    {
        Bit8    data[16];

        bool IsValid() const NN_NOEXCEPT
        {
            for (auto d : data)
            {
                if (d != 0)
                {
                    return true;
                }
            }

            return false;
        }

        bool operator == (const ContentId& rhs) const
        {
            for (size_t i = 0; i < sizeof(data); i++)
            {
                if (rhs.data[i] != data[i])
                {
                    return false;
                }
            }

            return true;
        }
    };
}}
