﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      ncm モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_NCM_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_NCM_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_NCM_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_NCM_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_NCM_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_NCM_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_NCM_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_NCM_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_NCM_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_NCM_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_NCM_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_NCM_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_NCM_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_NCM_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_NCM_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_NCM_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_NCM_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_NCM_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_NCM_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_NCM_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(ncm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_NCM_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Trace, 0, format, args)
#define NN_DETAIL_NCM_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Trace, 1, format, args)
#define NN_DETAIL_NCM_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Trace, 2, format, args)
#define NN_DETAIL_NCM_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Trace, 3, format, args)

#define NN_DETAIL_NCM_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Info, 0, format, args)
#define NN_DETAIL_NCM_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Info, 1, format, args)
#define NN_DETAIL_NCM_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Info, 2, format, args)
#define NN_DETAIL_NCM_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Info, 3, format, args)

#define NN_DETAIL_NCM_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Warn, 0, format, args)
#define NN_DETAIL_NCM_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Warn, 1, format, args)
#define NN_DETAIL_NCM_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Warn, 2, format, args)
#define NN_DETAIL_NCM_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Warn, 3, format, args)

#define NN_DETAIL_NCM_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Error, 0, format, args)
#define NN_DETAIL_NCM_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Error, 1, format, args)
#define NN_DETAIL_NCM_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Error, 2, format, args)
#define NN_DETAIL_NCM_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Error, 3, format, args)

#define NN_DETAIL_NCM_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Fatal, 0, format, args)
#define NN_DETAIL_NCM_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Fatal, 1, format, args)
#define NN_DETAIL_NCM_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Fatal, 2, format, args)
#define NN_DETAIL_NCM_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(ncm, Fatal, 3, format, args)

#define NN_DETAIL_NCM_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Trace, 0, text, length)
#define NN_DETAIL_NCM_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Trace, 1, text, length)
#define NN_DETAIL_NCM_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Trace, 2, text, length)
#define NN_DETAIL_NCM_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Trace, 3, text, length)

#define NN_DETAIL_NCM_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Info, 0, text, length)
#define NN_DETAIL_NCM_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Info, 1, text, length)
#define NN_DETAIL_NCM_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Info, 2, text, length)
#define NN_DETAIL_NCM_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Info, 3, text, length)

#define NN_DETAIL_NCM_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Warn, 0, text, length)
#define NN_DETAIL_NCM_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Warn, 1, text, length)
#define NN_DETAIL_NCM_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Warn, 2, text, length)
#define NN_DETAIL_NCM_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Warn, 3, text, length)

#define NN_DETAIL_NCM_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Error, 0, text, length)
#define NN_DETAIL_NCM_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Error, 1, text, length)
#define NN_DETAIL_NCM_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Error, 2, text, length)
#define NN_DETAIL_NCM_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Error, 3, text, length)

#define NN_DETAIL_NCM_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Fatal, 0, text, length)
#define NN_DETAIL_NCM_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Fatal, 1, text, length)
#define NN_DETAIL_NCM_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Fatal, 2, text, length)
#define NN_DETAIL_NCM_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(ncm, Fatal, 3, text, length)
