﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/svc/svc_BaseType.h>
#include <nn/svc/svc_ServerType.h>

namespace nn {
namespace ldr {

    enum ProgramInfoFlag
    {
        ProgramInfoFlag_ProgramTypeMask = (3u << 0),
        ProgramInfoFlag_Application     = (1u << 0),
        ProgramInfoFlag_Applet          = (2u << 0),
        ProgramInfoFlag_EnableDebug     = (1u << 2),
    };

    struct ProgramInfo
    {
        uint8_t     threadPriority;
        uint8_t     idealCoreNumber;
        Bit16       flags;
        uint32_t    stackSize;
        Bit64       programId;

        uint32_t    sacdSize;
        uint32_t    sacSize;
        uint32_t    facdSize;
        uint32_t    facSize;

        Bit8        capabilities[992];
    };
    NN_STATIC_ASSERT(sizeof(ProgramInfo) == 1024);

    struct ArgumentRegionHeader
    {
        int32_t regionSize;
        int32_t argumentSize;
        Bit8    padding[0x20 - 8];
    };

    struct PinId
    {
        Bit64 value;
    };

    inline bool operator == (const PinId& lhs, const PinId& rhs) NN_NOEXCEPT
    {
        return lhs.value == rhs.value;
    }
    inline bool operator != (const PinId& lhs, const PinId& rhs) NN_NOEXCEPT
    {
        return ! (lhs == rhs);
    }

    struct ModuleInfo
    {
        Bit8        moduleId[32];
        uint64_t    address;
        uint64_t    size;
    };

} // end of namespace ldr
} // end of namespace nn
