﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  htclow のモジュールに関する API
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/htclow/htclow_ModuleTypes.h>

namespace nn { namespace htclow {

/**
*   @brief      モジュール構造体を初期化します
*
*   @param[out] pOutModule  モジュール構造体
*   @param[in]  id          モジュール識別子
*
*   @details    モジュール構造体を初期化します。
*
*   @pre        - モジュール構造体が未初期化
*
*   @post       - モジュール構造体が初期化済
*/
void InitializeModule(ModuleType* pOutModule, ModuleId id) NN_NOEXCEPT;

/**
*   @brief      モジュール構造体を初期化します
*
*   @param[out] pOutModule  モジュール構造体
*
*   @details    モジュール構造体を未初期化状態にします。
*
*   @pre        - モジュール構造体が初期化済
*
*   @post       - モジュール構造体が未初期化
*/
void FinalizeModule(ModuleType* pOutModule) NN_NOEXCEPT;

}}
