﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/gc/detail/gc_Types.h>
#include <nn/gc/detail/gc_Define.h>
#include <nn/os.h>

namespace nn { namespace gc {
namespace detail {

class ThreadInterface
{
    NN_DISALLOW_COPY(ThreadInterface);

public:
    ThreadInterface() NN_NOEXCEPT;
    void InitializeThread(char* const threadStack, const size_t threadStackSize, const char* threadNamePointer, const int threadPriority) NN_NOEXCEPT;
    void FinalizeThread() NN_NOEXCEPT;

protected:
    static void RunThreadFunction(void* pThis) NN_NOEXCEPT
    {
        static_cast<ThreadInterface*>(pThis)->RunThreadFunctionImpl();
    }
    // メインの動作
    virtual void RunThreadFunctionImpl() NN_NOEXCEPT;
    virtual void InitializeWaitEvents() NN_NOEXCEPT;
    virtual void FinalizeWaitEvents() NN_NOEXCEPT;

protected:
    nn::os::ThreadType m_Thread;

    // イベント待ち受け
    nn::os::MultiWaitType m_Waiter;
    nn::os::MultiWaitHolderType m_ThreadEndEventHolder;
    // イベント
    nn::os::EventType m_ThreadEndEvent;
};

} } }
