﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace fssrv {

    typedef nn::fs::SaveDataAttribute SaveDataIndexerKey;

    enum class SaveDataState : uint8_t
    {
        None = 0,
        Deleting,
        Corrupted,
        DeletionRegistered,
        Extending,
    };

    struct SaveDataIndexerValue
    {
        nn::fs::SaveDataId id;
        int64_t size;
        int64_t _reserved1;
        nn::fs::SaveDataSpaceId spaceId;
        SaveDataState state;
        uint8_t _reserved2[38];
    };
    static_assert(sizeof(SaveDataIndexerValue) == 64, "sizeof(nn::fssrv::SaveDataIndexerValue) must be 64.");
    NN_STATIC_ASSERT(std::is_pod<SaveDataIndexerValue>::value);
}}
