﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fssrv/sf/fssrv_IProgramRegistry.h>

namespace nn { namespace fssrv {

    namespace detail
    {
        class ProgramInfo;
    }
    class ProgramRegistryImpl
    {
        NN_DISALLOW_COPY(ProgramRegistryImpl);
        NN_DISALLOW_MOVE(ProgramRegistryImpl);
    public:
        ProgramRegistryImpl() NN_NOEXCEPT;
        ~ProgramRegistryImpl() NN_NOEXCEPT;

        // fsp-pr interface
        Result RegisterProgram(std::uint64_t processId, std::uint64_t programId, uint8_t storageId, const nn::sf::InBuffer& fsAccessControlData, std::int64_t dataSize, const nn::sf::InBuffer& fsAccessControlDesc, std::int64_t descSize) NN_NOEXCEPT;
        Result UnregisterProgram(std::uint64_t processId) NN_NOEXCEPT;
        Result SetEnabledProgramVerification(bool isEnabled) NN_NOEXCEPT;
        Result SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT;

        // internal interface
        Result GetProgramInfo(std::shared_ptr<detail::ProgramInfo>* pOutValue, uint64_t processId) NN_NOEXCEPT;
        Result GetProgramInfoByProgramId(std::shared_ptr<detail::ProgramInfo>* pOutValue, Bit64 programId) NN_NOEXCEPT;

    private:
        nn::Bit64 m_ProcessId;
    };

    class InvalidProgramRegistryImpl
    {
    public:
        Result RegisterProgram(std::uint64_t processId, std::uint64_t programId, uint8_t storageId, const nn::sf::InBuffer& fsAccessControlData, std::int64_t dataSize, const nn::sf::InBuffer& fsAccessControlDesc, std::int64_t descSize) NN_NOEXCEPT
        {
            NN_UNUSED(processId);
            NN_UNUSED(programId);
            NN_UNUSED(storageId);
            NN_UNUSED(fsAccessControlData);
            NN_UNUSED(dataSize);
            NN_UNUSED(fsAccessControlDesc);
            NN_UNUSED(descSize);
            return nn::fs::ResultPortAcceptableCountLimited();
        }
        Result UnregisterProgram(std::uint64_t processId) NN_NOEXCEPT
        {
            NN_UNUSED(processId);
            return nn::fs::ResultPortAcceptableCountLimited();
        }
        Result SetEnabledProgramVerification(bool isEnabled) NN_NOEXCEPT
        {
            NN_UNUSED(isEnabled);
            return nn::fs::ResultPortAcceptableCountLimited();
        }
        Result SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_UNUSED(processId);
            return nn::fs::ResultPortAcceptableCountLimited();
        }
    };
}}

