﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <mutex>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/time.h>
#include <nn/fssrv/sf/fssrv_IFileSystemProxy.h>
#include <nn/fssrv/detail/fssrv_ISaveDataTransferCoreInterface.h>
#include <nn/fssystem/fs_ServiceContext.h>
#include <nn/fs/fs_SaveDataPrivate.h>
#include <nn/fs/fs_Directory.h>
#include <nn/fssystem/fs_Utility.h>
#include <nn/fssrv/detail/fssrv_IFileSystemProxyForAdapter.h>
#include <nn/fssrv/fssrv_SaveDataInfoFilter.h>

namespace nn { namespace ncm {
    struct ApplicationId;
}}

namespace nn { namespace fs { namespace fsa {
    class IFileSystem;
}}}

namespace nn { namespace fs {
    class IStorage;
}}

namespace nn { namespace fssystem {
    struct Hash;
    typedef Hash NcaDigest;
}}


namespace nn { namespace fssrv {

    namespace detail
    {
        class ProgramInfo;
        class FileSystemProxyCoreImpl;
        struct Accessibility;
        class FatFileSystemCacheManager;
    }

    class FileSystemProxyImpl : public detail::IFileSystemProxyForAdapter, public detail::ISaveDataTransferCoreInterface
    {
        NN_DISALLOW_COPY(FileSystemProxyImpl);
        NN_DISALLOW_MOVE(FileSystemProxyImpl);
    public:
        FileSystemProxyImpl() NN_NOEXCEPT;
        ~FileSystemProxyImpl() NN_NOEXCEPT;

        // sf
        nn::Result OpenFileSystemWithPatch(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, nn::ncm::ProgramId programId, std::uint32_t type) NN_NOEXCEPT;
        nn::Result SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result OpenDataFileSystemByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT;
        nn::Result OpenFileSystemWithId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path, nn::Bit64 programId, std::uint32_t type) NN_NOEXCEPT;
        nn::Result OpenDataFileSystemByProgramId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, nn::ncm::ProgramId programId) NN_NOEXCEPT;
        nn::Result OpenBisFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path, std::uint32_t id) NN_NOEXCEPT;
        nn::Result OpenBisStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, std::uint32_t id) NN_NOEXCEPT;
        nn::Result InvalidateBisCache() NN_NOEXCEPT;
        nn::Result OpenHostFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
        nn::Result OpenSdCardFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT;
        nn::Result FormatSdCardFileSystem() NN_NOEXCEPT;
        nn::Result FormatSdCardDryRun() NN_NOEXCEPT;
        nn::Result IsExFatSupported(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result RegisterSaveDataFileSystemAtomicDeletion(nn::sf::InBuffer saveDataIdArray) NN_NOEXCEPT;
        nn::Result DeleteSaveDataFileSystem(std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result DeleteSaveDataFileSystemBySaveDataSpaceId(std::uint8_t indexerSpaceId, nn::fs::SaveDataId saveDataId) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result DeleteSaveDataFileSystemBySaveDataAttribute(std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT;
        nn::Result CreateSaveDataFileSystem(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo) NN_NOEXCEPT;
        nn::Result CreateSaveDataFileSystemBySystemSaveDataId(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo) NN_NOEXCEPT;
        nn::Result CreateSaveDataFileSystemWithHashSalt(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo, const nn::fs::HashSalt& salt) NN_NOEXCEPT;
        nn::Result ExtendSaveDataFileSystem(std::uint8_t spaceId, nn::fs::SaveDataId saveDataId, int64_t saveDataAvailableSize, int64_t saveDataJournalSize) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result SwapSaveDataKeyAndState(std::uint8_t spaceId, nn::fs::SaveDataId lhsSaveDataId, nn::fs::SaveDataId rhsSaveDataId) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result OpenGameCardStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, std::uint32_t handle, std::uint32_t partition) NN_NOEXCEPT;
        nn::Result OpenGameCardFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t handle, std::uint32_t partition) NN_NOEXCEPT;
        nn::Result OpenSaveDataFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT;
        nn::Result OpenReadOnlySaveDataFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT;
        nn::Result OpenSaveDataFileSystemBySystemSaveDataId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute) NN_NOEXCEPT;
        nn::Result ReadSaveDataFileSystemExtraDataBySaveDataSpaceId(const nn::sf::OutBuffer& buffer, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result ReadSaveDataFileSystemExtraData(const nn::sf::OutBuffer& buffer, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result WriteSaveDataFileSystemExtraData(std::uint64_t saveDataId, std::uint8_t saveDataSpaceId, const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result WriteSaveDataFileSystemExtraDataWithMask(std::uint64_t saveDataId, std::uint8_t saveDataSpaceId, const nn::sf::InBuffer& extraDataValue, const nn::sf::InBuffer& extraDataMask) NN_NOEXCEPT;
        nn::Result OpenSaveDataInfoReader(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue) NN_NOEXCEPT;
        nn::Result OpenSaveDataInfoReaderBySaveDataSpaceId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue, std::uint8_t saveDataSpaceId) NN_NOEXCEPT;
        nn::Result OpenSaveDataInfoReaderWithFilter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue, std::uint8_t saveDataSpaceId, const fs::SaveDataFilter& filter) NN_NOEXCEPT;
        nn::Result OpenSaveDataInternalStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result QuerySaveDataInternalStorageTotalSize(nn::sf::Out<int64_t> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result GetSaveDataCommitId(nn::sf::Out<int64_t> outValue, std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result UpdateSaveDataMacForDebug(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result OpenSaveDataInfoReaderOnlyCacheStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue) NN_NOEXCEPT;
        nn::Result OpenSaveDataMetaFile(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFile>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute, std::uint32_t metaType) NN_NOEXCEPT;
        nn::Result OpenSaveDataTransferManager(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferManager>> outValue) NN_NOEXCEPT;
        nn::Result OpenSaveDataTransferManagerVersion2(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferManagerWithDivision>> outValue) NN_NOEXCEPT;
        nn::Result OpenSaveDataTransferProhibiter(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataTransferProhibiter>> outValue, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result ListAccessibleSaveDataOwnerId(nn::sf::Out<std::int32_t> outValue, const nn::sf::OutBuffer& outBuffer, nn::ncm::ProgramId programId, std::int32_t offset, std::int32_t count) NN_NOEXCEPT;
        nn::Result OpenImageDirectoryFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT;
        nn::Result OpenContentStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT;
        nn::Result OpenCloudBackupWorkStorageFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint32_t storageId) NN_NOEXCEPT;
        nn::Result OpenDataStorageByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue) NN_NOEXCEPT;
        nn::Result OpenDataStorageByProgramId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, nn::ncm::ProgramId programId) NN_NOEXCEPT;
        nn::Result OpenDataStorageByDataId(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue, nn::ncm::DataId dataId, nn::Bit8 storageId) NN_NOEXCEPT;
        nn::Result OpenPatchDataStorageByCurrentProcess(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IStorage>> outValue) NN_NOEXCEPT;
        nn::Result OpenDeviceOperator(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator>> outValue) NN_NOEXCEPT;
        nn::Result OpenSdCardDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT;
        nn::Result OpenGameCardDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT;
        nn::Result OpenSystemDataUpdateEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue) NN_NOEXCEPT;
        nn::Result NotifySystemDataUpdateEvent() NN_NOEXCEPT;
        nn::Result SimulateDeviceDetectionEvent(std::uint32_t deviceType, std::uint32_t simulatingDetectionMode, bool isWithEvent) NN_NOEXCEPT;
        nn::Result SetCurrentPosixTimeWithTimeDifference(std::int64_t posixTime, std::int32_t timeDifference) NN_NOEXCEPT;
        nn::Result GetFreeSpaceSizeForSaveData(nn::sf::Out<std::int64_t> outValue, std::uint8_t saveDataSpaceId) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result GetRightsId(nn::sf::Out<fs::RightsId> outValue, nn::ncm::ProgramId programId, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result GetRightsIdByPath(nn::sf::Out<fs::RightsId> outValue, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
        nn::Result GetRightsIdAndKeyGenerationByPath(nn::sf::Out<fs::RightsId> outRightsId, nn::sf::Out<std::uint8_t> outKeyGeneration, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
        nn::Result RegisterExternalKey(const fs::RightsId& rightsId, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT;
        nn::Result UnregisterAllExternalKey() NN_NOEXCEPT;
        nn::Result SetSdCardEncryptionSeed(const fs::EncryptionSeed& seed) NN_NOEXCEPT;
        nn::Result QuerySaveDataTotalSize(nn::sf::Out<int64_t> outValue, std::int64_t saveDataSize, std::int64_t saveDataJournalSize) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result GetAndClearErrorInfo(nn::sf::Out<fs::FileSystemProxyErrorInfo> outValue) NN_NOEXCEPT;
        nn::Result VerifySaveDataFileSystem(std::uint64_t saveDataId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result VerifySaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId, const nn::sf::OutBuffer& workBuffer) NN_NOEXCEPT;
        nn::Result CorruptSaveDataFileSystem(std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result CorruptSaveDataFileSystemBySaveDataSpaceId(std::uint8_t saveDataSpaceId, std::uint64_t saveDataId) NN_NOEXCEPT;
        nn::Result CreatePaddingFile(std::int64_t paddingSize) NN_NOEXCEPT;
        nn::Result DeleteAllPaddingFiles() NN_NOEXCEPT;
        nn::Result SetBisRootForHost(std::uint32_t id, const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
        nn::Result SetSaveDataSize(std::int64_t size, std::int64_t journalSize) NN_NOEXCEPT;
        nn::Result SetSaveDataRootPath(const nn::fssrv::sf::FspPath& path) NN_NOEXCEPT;
        nn::Result DisableAutoSaveDataCreation() NN_NOEXCEPT;
        nn::Result SetGlobalAccessLogMode(uint32_t accessLogMode) NN_NOEXCEPT;
        nn::Result GetGlobalAccessLogMode(nn::sf::Out<uint32_t> outValue) NN_NOEXCEPT;
        nn::Result OutputAccessLogToSdCard(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result RegisterUpdatePartition() NN_NOEXCEPT;
        nn::Result OpenRegisteredUpdatePartition(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue) NN_NOEXCEPT;
        nn::Result GetAndClearMemoryReportInfo(nn::sf::Out<nn::fs::MemoryReportInfo> outValue) NN_NOEXCEPT;
        nn::Result OverrideSaveDataTransferTokenSignVerificationKey(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result SetSdCardAccessibility(bool isAccessible) NN_NOEXCEPT;
        nn::Result IsSdCardAccessible(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result IsSignedSystemPartitionOnSdCardValid(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result FindSaveDataWithFilter(nn::sf::Out<std::int64_t> outValue, const nn::sf::OutBuffer& outEntries, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataFilter& filter) NN_NOEXCEPT;
        nn::Result DeleteCacheStorage(std::uint16_t index) NN_NOEXCEPT;
        nn::Result GetCacheStorageSize(nn::sf::Out<std::int64_t> outSize, nn::sf::Out<std::int64_t> outJournalSize, std::uint16_t index) NN_NOEXCEPT;
        nn::Result OpenAccessFailureDetectionEventNotifier(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>> outValue, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result GetAccessFailureDetectionEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
        nn::Result IsAccessFailureDetected(nn::sf::Out<bool> outValue, nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result ResolveAccessFailure(nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result AbandonAccessFailure(nn::Bit64 processId) NN_NOEXCEPT;
        nn::Result SetDataStorageRedirectTarget(nn::ncm::StorageId storageId) NN_NOEXCEPT;

        // sf for loader
        nn::Result OpenCodeFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path, nn::ncm::ProgramId programId) NN_NOEXCEPT;
        nn::Result IsArchivedProgram(nn::sf::Out<bool> outValue, nn::Bit64 processId) NN_NOEXCEPT;

        nn::Result OpenMultiCommitManager(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IMultiCommitManager>> outValue) NN_NOEXCEPT;

    public:
        nn::Result CleanUpSaveData() NN_NOEXCEPT;
        nn::Result CleanUpTemporaryStorage() NN_NOEXCEPT;
        nn::Result CompleteSaveDataExtension() NN_NOEXCEPT;
        nn::Result FixSaveData() NN_NOEXCEPT;
        nn::Result TryAcquireSaveDataEntryOpenCountSemaphore(std::unique_lock<fssystem::SemaphoreAdaptor>* pOutValue) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result TryAcquireAddOnContentOpenCountSemaphore(std::unique_lock<fssystem::SemaphoreAdaptor>* pOutValue) NN_NOEXCEPT;
        nn::Result TryAcquireRomMountCountSemaphore(std::unique_lock<fssystem::SemaphoreAdaptor>* pOutValue) NN_NOEXCEPT;
        nn::Result TryAcquireSaveDataMountCountSemaphore(std::unique_lock<fssystem::SemaphoreAdaptor>* pOutValue) NN_NOEXCEPT;
        nn::Result OpenDataStorageCore(std::shared_ptr<fs::IStorage>* outValue, fssystem::NcaDigest* pOutDigest, nn::Bit64 programIdValue, nn::ncm::StorageId storageId) NN_NOEXCEPT NN_OVERRIDE;
        void IncrementRomFsRemountForDataCorruptionCount() NN_NOEXCEPT NN_OVERRIDE;
        void IncrementRomFsUnrecoverableDataCorruptionByRemountCount() NN_NOEXCEPT NN_OVERRIDE;
        void IncrementRomFsRecoveredByInvalidateCacheCount() NN_NOEXCEPT NN_OVERRIDE;

        nn::Result CheckSaveDataFile(nn::fs::SaveDataId saveDataId, nn::fs::SaveDataSpaceId saveDataSpaceId) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result CreateSaveDataFileSystemCore(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo, const nn::fs::SaveDataHashSalt& hashSalt, bool isImportable) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result GetSaveDataInfo(nn::fs::SaveDataInfo* outValue, nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataAttribute saveDataAttribute) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result ReadSaveDataFileSystemExtraDataCore(nn::fs::SaveDataExtraData* outValue, nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataId saveDataId, bool isTemporaryFs) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result WriteSaveDataFileSystemExtraDataCore(nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataId saveDataId, const nn::fs::SaveDataExtraData& extraData, nn::fs::SaveDataType saveDataType, bool updateTimeStampAndHash) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result FinalizeSaveDataCreation(nn::fs::SaveDataId saveDataId, nn::fs::SaveDataSpaceId saveDataSpaceId) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result CancelSaveDataCreation(nn::fs::SaveDataId saveDataId, nn::fs::SaveDataSpaceId saveDataSpaceId) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result OpenSaveDataFile(std::shared_ptr<fs::fsa::IFile>* outValue, nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataId saveDataId, nn::fs::OpenMode mode) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result OpenSaveDataMetaFileRaw(std::shared_ptr<fs::fsa::IFile>* outValue, nn::fs::SaveDataSpaceId spaceId, nn::fs::SaveDataId saveDataId, fs::SaveDataMetaType metaType, nn::fs::OpenMode mode) NN_NOEXCEPT NN_OVERRIDE;
        nn::Result OpenSaveDataInternalStorageFileSystemCore(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue, nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataId saveDataId) NN_NOEXCEPT NN_OVERRIDE;

        bool IsAccessFailureDetectionObserved() NN_NOEXCEPT NN_OVERRIDE;

    private:
        nn::Result CreateSaveDataFileSystemCore(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo, const nn::fs::SaveDataHashSalt& hashSalt) NN_NOEXCEPT;
        nn::Result CreateSaveDataFileSystemWithHashSaltImpl(const nn::fs::SaveDataAttribute& attribute, const nn::fs::SaveDataCreationInfo& creationInfo, const nn::fs::SaveDataMetaInfo& metaInfo, const nn::fs::SaveDataHashSalt& hashSalt) NN_NOEXCEPT;
        nn::Result DeleteSaveDataFileSystemCore(nn::fs::SaveDataSpaceId saveDataSpaceId, nn::fs::SaveDataId saveDataId) NN_NOEXCEPT;
        nn::Result DeleteSaveDataFileSystemBySaveDataSpaceIdCore(std::uint8_t indexerSpaceId, nn::fs::SaveDataId saveDataId) NN_NOEXCEPT;
        nn::Result DeleteSaveDataFileSystemCommon(std::uint8_t indexerSpaceId, nn::fs::SaveDataId saveDataId) NN_NOEXCEPT;
        nn::Result OpenSaveDataFileSystemCore(std::shared_ptr<nn::fs::fsa::IFileSystem>* pOutFileSystem, nn::fs::SaveDataId* pOutSaveDataId, nn::fs::SaveDataSpaceId saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute, bool isReadOnly) NN_NOEXCEPT;
        nn::Result OpenUserSaveDataFileSystemCore(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute, const detail::ProgramInfo* pProgramInfo, bool isReadOnly) NN_NOEXCEPT;
        nn::Result OpenUserSaveDataFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, std::uint8_t saveDataSpaceId, const nn::fs::SaveDataAttribute& attribute, bool isReadOnly) NN_NOEXCEPT;
        nn::Result GetProgramInfo(std::shared_ptr<detail::ProgramInfo>* outProgramInfo) NN_NOEXCEPT;
        nn::Result GetProgramInfoByProcessId(std::shared_ptr<detail::ProgramInfo>* outProgramInfo, Bit64 processId) NN_NOEXCEPT;
        nn::Result GetProgramInfoByProgramId(std::shared_ptr<detail::ProgramInfo>* outProgramInfo, Bit64 programIdValue) NN_NOEXCEPT;
        nn::Result GetAccesibilityForSaveData(detail::Accessibility* outValue, const detail::ProgramInfo* pProgramInfo, nn::fs::SaveDataId saveDataId, nn::fs::SaveDataSpaceId spaceId, bool isTemporaryFs) NN_NOEXCEPT;
        nn::Result OpenDataFileSystemCore(std::shared_ptr<fs::fsa::IFileSystem>* outValue, nn::Bit64 programIdValue, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result CreateEmptyThumbnailFile(nn::fs::SaveDataSpaceId spaceId, nn::fs::SaveDataId saveDataId) NN_NOEXCEPT;
        nn::Result OpenSaveDataInfoReaderOnlyCacheStorage(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::ISaveDataInfoReader>> outValue, std::uint8_t saveDataSpaceId) NN_NOEXCEPT;
        nn::Result GetCacheStorageSpaceId(fs::SaveDataSpaceId* pOutSpaceId) NN_NOEXCEPT;
        nn::Result GetCacheStorageSpaceId(fs::SaveDataSpaceId* pOutSpaceId, nn::Bit64 programIdValue) NN_NOEXCEPT;
        nn::Result FindCacheStorage(nn::fs::SaveDataInfo* pOutValue, fs::SaveDataSpaceId* pOutSpaceId, uint16_t index) NN_NOEXCEPT;
        nn::Result WriteSaveDataFileSystemExtraDataWithMaskCore(nn::fs::SaveDataId saveDataId, nn::fs::SaveDataSpaceId saveDataSpaceId, const nn::fs::SaveDataExtraData& extraDataValue, const nn::fs::SaveDataExtraData& extraDataMask) NN_NOEXCEPT;
        nn::Result FindSaveDataWithFilterImpl(int64_t* outValue, nn::fs::SaveDataInfo* outInfoBuffer, nn::fs::SaveDataSpaceId saveDataSpaceId, const nn::fssrv::SaveDataInfoFilter& filter) NN_NOEXCEPT;

    private:
        detail::FileSystemProxyCoreImpl* m_Impl;
        nn::Bit64 m_ProcessId;
        int64_t m_SaveDataSize; // will be deprecated
        int64_t m_SaveDataJournalSize; // will be deprecated
        char m_SaveDataRootPathBuffer[nn::fs::EntryNameLengthMax];
        bool m_EnableAutoSaveDataCreation;
        fssystem::SemaphoreAdaptor m_SaveDataEntryOpenCountSemaphore;
        fssystem::SemaphoreAdaptor m_AddOnContentOpenCountSemaphore;
        fssystem::SemaphoreAdaptor m_RomMountCountSemaphore;
        fssystem::SemaphoreAdaptor m_SaveDataMountCountSemaphore;
    };
    nn::Result GetCurrentCalendarTime(nn::time::CalendarTime* pOutCalendarTime) NN_NOEXCEPT;
    void InitializeSaveDataFileSystemCacheManager(int maxCacheCount) NN_NOEXCEPT;
    nn::fssrv::detail::FileSystemProxyCoreImpl* GetFileSystemProxyCoreImpl() NN_NOEXCEPT;
    nn::fssrv::detail::FatFileSystemCacheManager* GetFatFileSystemCacheManager() NN_NOEXCEPT;
    Result FlushFatCache() NN_NOEXCEPT;

    class InvalidFileSystemProxyImplForLoader
    {
    public:
        nn::Result OpenCodeFileSystem(nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IFileSystem>> outValue, const nn::fssrv::sf::FspPath& path, nn::ncm::ProgramId programId) NN_NOEXCEPT
        {
            NN_UNUSED(outValue);
            NN_UNUSED(path);
            NN_UNUSED(programId);
            return nn::fs::ResultPortAcceptableCountLimited();
        }
        nn::Result IsArchivedProgram(nn::sf::Out<bool> outValue, nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_UNUSED(outValue);
            NN_UNUSED(processId);
            return nn::fs::ResultPortAcceptableCountLimited();
        }
        nn::Result SetCurrentProcess(nn::Bit64 processId) NN_NOEXCEPT
        {
            NN_UNUSED(processId);
            return nn::fs::ResultPortAcceptableCountLimited();
        }
    };

}}
