﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fssrv/fssrv_IFileSystemCreator.h>
#include <nn/nn_Allocator.h>
#include <nn/os/os_Mutex.h>
#include <nn/fs/fs_ErrorInfoPrivate.h>


namespace nn {

namespace fssystem
{
    class ProxyFileSystem;
}

namespace fssrv { namespace fscreator {

    class SdCardProxyFileSystemCreator : public ISdCardProxyFileSystemCreator
    {
        NN_DISALLOW_COPY(SdCardProxyFileSystemCreator);
        NN_DISALLOW_MOVE(SdCardProxyFileSystemCreator);

    private:
        Result OpenSdCardFileSystem(std::shared_ptr<nn::fs::fsa::IFileSystem>* pOutFileSystem, bool isUncache) NN_NOEXCEPT;

    public:
        SdCardProxyFileSystemCreator(
            ISdStorageCreator* pSdStorageCreator,
            IFatFileSystemCreator* pFatFsCreator,
            detail::FatFileSystemCacheManager* pFatFileSystemCacheManager
        ) NN_NOEXCEPT
            : g_ProxySdFatFileSystemCacheMutex(false)
            , m_pSdStorageCreator(pSdStorageCreator)
            , m_pFatFsCreator(pFatFsCreator)
            , m_pFatFileSystemCacheManager(pFatFileSystemCacheManager)
        {
        }

    public:
        virtual Result Create(std::shared_ptr<fs::fsa::IFileSystem>* pOutFileSystem) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result Format(bool isUncache) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result Format() NN_NOEXCEPT NN_OVERRIDE;
        virtual void Initialize(fs::FileSystemProxyErrorInfo* pErrorInfo, os::Mutex* pErrorInfoMutex) NN_NOEXCEPT NN_OVERRIDE;

    private:
        std::shared_ptr<nn::fssystem::ProxyFileSystem> g_ProxySdFatFileSystemCache;
        os::Mutex g_ProxySdFatFileSystemCacheMutex;

        ISdStorageCreator* const m_pSdStorageCreator;
        IFatFileSystemCreator* const m_pFatFsCreator;
        detail::FatFileSystemCacheManager* const m_pFatFileSystemCacheManager;

        fs::FileSystemProxyErrorInfo* m_pErrorInfo = nullptr;
        os::Mutex* m_pErrorInfoMutex = nullptr;
    };

}}}
