﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/dd.h>
#include <nn/fssrv/fssrv_IFileSystemCreator.h>

namespace nn {
    class MemoryResource;
}

namespace nn { namespace fssrv { namespace fscreator {


    class GameCardStorageCreator : public IGameCardStorageCreator
    {
        NN_DISALLOW_COPY(GameCardStorageCreator);
        NN_DISALLOW_MOVE(GameCardStorageCreator);
    public:
        explicit GameCardStorageCreator(nn::MemoryResource* pAllocator) NN_NOEXCEPT;
        ~GameCardStorageCreator() NN_NOEXCEPT;
        virtual Result CreateReadOnly      (nn::fs::GameCardHandle handle, std::shared_ptr<fs::IStorage>* outValue) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result CreateSecureReadOnly(nn::fs::GameCardHandle handle, std::shared_ptr<fs::IStorage>* outValue) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result CreateWriteOnly     (nn::fs::GameCardHandle handle, std::shared_ptr<fs::IStorage>* outValue) NN_NOEXCEPT NN_OVERRIDE;

    private:

        nn::MemoryResource* m_Allocator;
    };




}}}
