﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/os.h>
#include <nn/dd.h>
#include <nn/fssrv/fssrv_IFileSystemCreator.h>

namespace nn {
    class MemoryResource;
}

namespace nn { namespace fssrv { namespace fscreator {

    class GameCardRootPartition;

    class GameCardFileSystemCreator : public IGameCardFileSystemCreator
    {
        NN_DISALLOW_COPY(GameCardFileSystemCreator);
        NN_DISALLOW_MOVE(GameCardFileSystemCreator);
    public:
        GameCardFileSystemCreator(nn::MemoryResource* pAllocator, GameCardStorageCreator* pGameCardStorageCreator) NN_NOEXCEPT;
        ~GameCardFileSystemCreator() NN_NOEXCEPT;
        virtual Result Create(std::shared_ptr<nn::fs::fsa::IFileSystem>* outValue, nn::fs::GameCardHandle handle, nn::fs::GameCardPartition partition) NN_NOEXCEPT NN_OVERRIDE;

    private:


    private:
        nn::MemoryResource* m_pAllocator;
        IGameCardStorageCreator* m_pGameCardStorageCreator;

        std::unique_ptr<GameCardRootPartition> m_CachedRoot;
        nn::os::Mutex m_CachedRootMutex;
    };

}}}
