﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdarg>
#include <nn/nn_Common.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_FormatString.h>
#include <nn/fs/fs_ResultPrivate.h>
#include "shim/fs_FileSystemProxyServiceObject.h"

namespace nn { namespace fs {

    inline void Replace(char* pStr, size_t strLenMax, char oldChar, char newChar) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pStr);

        for( auto pChar = pStr; pChar < pStr + strLenMax && *pChar != '\0'; ++pChar )
        {
            if( *pChar == oldChar )
            {
                *pChar = newChar;
            }
        }
    }

    inline Result FspPathPrintf(fssrv::sf::FspPath* outPath, const char* pFormat, ...) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(outPath);

        std::va_list vaList;
        va_start(vaList, pFormat);
        const auto length = util::VSNPrintf(outPath->str, sizeof(outPath->str), pFormat, vaList);
        va_end(vaList);
        NN_RESULT_THROW_UNLESS(static_cast<size_t>(length) < sizeof(outPath->str)
                               , ResultTooLongPath());

        Replace(outPath->str, sizeof(outPath->str) - 1, '\\', '/');

        NN_RESULT_SUCCESS;
    }

    Result VerifyPath(const char* path, int pathLengthMax, int nameLengthMax) NN_NOEXCEPT;

}}
