﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief マウント関連のプライベート API の宣言
*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace fs {

//! @name マウント関連プライベート API
//! @{

//--------------------------------------------------------------------------
/**
*   @brief      指定したパスを、fs が解釈できるパスに変換します。
*
*   @param[out] outPathBuffer             fs が解釈できるパスの出力先バッファ
*   @param[in]  pathBufferSize            outPathBuffer のバッファサイズ
*   @param[in]  path                      変換元のパス
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess               成功しました。
*
*   @pre
*       - outPathBuffer が有効なメモリを指している。
*       - path が @link entry_path 有効なパス @endlink である。
*       - path に含まれるマウント名が MountGameCardPartition(), MountBis(), MountContentStorage() に指定したマウント名である。
*/
Result ConvertToFsCommonPath(char* outPathBuffer, size_t pathBufferSize, const char* path) NN_NOEXCEPT;

//! @}

}} // namespace nn::fs

