﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  ローダー向けファイルシステム API の宣言
*/

#pragma once

#include<nn/nn_Common.h>
#include<nn/nn_Result.h>

namespace nn { namespace os {
    struct ProcessId;
}}

namespace nn { namespace fs {

//! @name  ローダー向けファイルシステム API
//! @{

//--------------------------------------------------------------------------
/**
*   @brief      指定したプロセスで実行されているプログラムがアーカイブされているかを調べます。
*
*   @param[in]  outValue アーカイブされている場合 true、されていない場合 false
*
*   @return     処理の結果が返ります。
*   @retval     ResultSuccess               成功しました。
*   @retval     ResultTargetNotFound        指定したプロセスで実行されているプログラムが見つかりません。
*
*   @pre
*       - outValue が有効なメモリを指している。
*/
Result IsArchivedProgram(bool* outValue, nn::os::ProcessId processId) NN_NOEXCEPT;

//! @}

}} // namespace nn::fs
