﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      eth モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_ETH_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(eth, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_ETH_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eth, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_ETH_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eth, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_ETH_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eth, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_ETH_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(eth, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_ETH_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(eth, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_ETH_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(eth, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_ETH_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(eth, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_ETH_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(eth, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_ETH_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(eth, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_ETH_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(eth, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_ETH_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(eth, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_ETH_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(eth, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_ETH_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eth, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_ETH_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eth, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_ETH_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eth, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_ETH_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(eth, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_ETH_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eth, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_ETH_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eth, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_ETH_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(eth, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_ETH_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Trace, 0, format, args)
#define NN_DETAIL_ETH_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Trace, 1, format, args)
#define NN_DETAIL_ETH_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Trace, 2, format, args)
#define NN_DETAIL_ETH_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Trace, 3, format, args)

#define NN_DETAIL_ETH_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Info, 0, format, args)
#define NN_DETAIL_ETH_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Info, 1, format, args)
#define NN_DETAIL_ETH_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Info, 2, format, args)
#define NN_DETAIL_ETH_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Info, 3, format, args)

#define NN_DETAIL_ETH_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Warn, 0, format, args)
#define NN_DETAIL_ETH_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Warn, 1, format, args)
#define NN_DETAIL_ETH_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Warn, 2, format, args)
#define NN_DETAIL_ETH_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Warn, 3, format, args)

#define NN_DETAIL_ETH_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Error, 0, format, args)
#define NN_DETAIL_ETH_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Error, 1, format, args)
#define NN_DETAIL_ETH_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Error, 2, format, args)
#define NN_DETAIL_ETH_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Error, 3, format, args)

#define NN_DETAIL_ETH_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Fatal, 0, format, args)
#define NN_DETAIL_ETH_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Fatal, 1, format, args)
#define NN_DETAIL_ETH_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Fatal, 2, format, args)
#define NN_DETAIL_ETH_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(eth, Fatal, 3, format, args)

#define NN_DETAIL_ETH_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(eth, Trace, 0, text, length)
#define NN_DETAIL_ETH_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eth, Trace, 1, text, length)
#define NN_DETAIL_ETH_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eth, Trace, 2, text, length)
#define NN_DETAIL_ETH_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eth, Trace, 3, text, length)

#define NN_DETAIL_ETH_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(eth, Info, 0, text, length)
#define NN_DETAIL_ETH_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(eth, Info, 1, text, length)
#define NN_DETAIL_ETH_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(eth, Info, 2, text, length)
#define NN_DETAIL_ETH_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(eth, Info, 3, text, length)

#define NN_DETAIL_ETH_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(eth, Warn, 0, text, length)
#define NN_DETAIL_ETH_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(eth, Warn, 1, text, length)
#define NN_DETAIL_ETH_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(eth, Warn, 2, text, length)
#define NN_DETAIL_ETH_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(eth, Warn, 3, text, length)

#define NN_DETAIL_ETH_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(eth, Error, 0, text, length)
#define NN_DETAIL_ETH_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eth, Error, 1, text, length)
#define NN_DETAIL_ETH_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eth, Error, 2, text, length)
#define NN_DETAIL_ETH_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eth, Error, 3, text, length)

#define NN_DETAIL_ETH_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(eth, Fatal, 0, text, length)
#define NN_DETAIL_ETH_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eth, Fatal, 1, text, length)
#define NN_DETAIL_ETH_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eth, Fatal, 2, text, length)
#define NN_DETAIL_ETH_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(eth, Fatal, 3, text, length)
