﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Driver Manager の HIPC サーバに関する公開ヘッダファイル
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/dt/detail/dt_IDeviceTree.h>

namespace nn { namespace dt { namespace server {

void Initialize() NN_NOEXCEPT;
void InitializeForDebug(const nn::Bit8* fdt, size_t size) NN_NOEXCEPT;
nn::sf::SharedPointer<nn::dt::detail::IDeviceTree> GetServiceObject() NN_NOEXCEPT;
void RegisterHipcServer() NN_NOEXCEPT;
void StartHipcServer() NN_NOEXCEPT;
void LoopHipcServer() NN_NOEXCEPT;

}}}
