﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief デバイスコードのカテゴリの定義
 */

#include <nn/devicecode/detail/devicecode_InnerFormat.h>

// ----------------------------------------------------------------------------------------
// Defined category list:
// DO NOT change values for existing categories without agreement with the owner of the id.
// ----------------------------------------------------------------------------------------

// Reserved category for invalid device code value
#define NN_DEVICECODE_CATEGORY_INVALID      0 // NOLINT(preprocessor/const)

//! GPIO ピンを指定するカテゴリ
#define NN_DEVICECODE_CATEGORY_GPIO         1 // NOLINT(preprocessor/const)

//! HID デバイスを指定するカテゴリ
#define NN_DEVICECODE_CATEGORY_HID 2 // NOLINT(preprocessor/const)

//! THERMAL_MONITOR デバイスを指定するカテゴリ
#define NN_DEVICECODE_CATEGORY_THERMAL_MONITOR 3 // NOLINT(preprocessor/const)

//! POWER_MONITOR デバイスを指定するカテゴリ
#define NN_DEVICECODE_CATEGORY_POWER_MONITOR 4 // NOLINT(preprocessor/const)

//! POWER_CONTROLLER デバイスを指定するカテゴリ
#define NN_DEVICECODE_CATEGORY_POWER_CONTROLLER 5 // NOLINT(preprocessor/const)

//! REGULATOR デバイスを指定するカテゴリ
#define NN_DEVICECODE_CATEGORY_REGULATOR 6 // NOLINT(preprocessor/const)

//! AUDIO_CODEC デバイスを指定するカテゴリ
#define NN_DEVICECODE_CATEGORY_AUDIO_CODEC 7 // NOLINT(preprocessor/const)

//! LIGHT_SENSOR デバイスを指定するカテゴリ
#define NN_DEVICECODE_CATEGORY_LIGHT_SENSOR 8 // NOLINT(preprocessor/const)

//! AV デバイスを指定するカテゴリ
#define NN_DEVICECODE_CATEGORY_AV 9 // NOLINT(preprocessor/const)

//! RTC デバイスを指定するカテゴリ
#define NN_DEVICECODE_CATEGORY_RTC 10 // NOLINT(preprocessor/const)

//! POWER_DELIVERY デバイスを指定するカテゴリ
#define NN_DEVICECODE_CATEGORY_POWER_DELIVERY 11 // NOLINT(preprocessor/const)

//! I2C_BUS を指定するカテゴリ
#define NN_DEVICECODE_CATEGORY_I2C_BUS 12 // NOLINT(preprocessor/const)

// Reserved category for temporary/test use
#define NN_DEVICECODE_CATEGORY_TEST         255 // NOLINT(preprocessor/const)
