﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   DD ライブラリで使用する共通の型や定数の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_NativeHandleTypes.h>

namespace nn { namespace dd {

//--------------------------------------------------------------------------
/**
 * @brief   メモリアクセス権を表す列挙型です。
 */
enum MemoryPermission
{
    MemoryPermission_None       = 0x0,  //!< メモリはアクセス禁止です。
    MemoryPermission_ReadOnly   = 0x1,  //!< メモリは読み込み専用です。
    MemoryPermission_WriteOnly  = 0x2,  //!< メモリは書き込み専用です。
    MemoryPermission_ReadWrite  = 0x3,  //!< メモリは読み書き可能です。
};

//-----------------------------------------------------------------------------
/**
 * @brief   プロセスを表すハンドルの型です
 */
typedef nn::os::NativeHandle    ProcessHandle;


//--------------------------------------------------------------------------

}} // namespace nn::dd

