﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   デバイスドライバ向けデバイスアドレス空間に関する公開ヘッダファイル
 */

#pragma once

#include <nn/dd/dd_Config.h>

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/dd/dd_Types.h>
#include <nn/os/os_NativeHandleTypes.h>


namespace nn { namespace dd {

//-----------------------------------------------------------------------------
/**
 * @brief   デバイスアドレス空間を扱うハンドルの型です
 */
typedef nn::os::NativeHandle    DeviceAddressSpaceHandle;


//-----------------------------------------------------------------------------
/**
 * @brief   デバイスアドレス空間における仮想アドレスを表す型です。
 *
 */
typedef uint64_t    DeviceVirtualAddress;


//-----------------------------------------------------------------------------
/**
 * @brief   デバイスアドレス空間を扱うための構造体です
 *
 * @details
 * メンバー変数を直接変更することは禁止です。 @n
 * 次の関数を介して、本構造体を利用してください。
 *
 * - @ref CreateDeviceAddressSpace()
 * - @ref DestroyDeviceAddressSpace()
 * - @ref AttachDeviceAddressSpace()
 * - @ref DetachDeviceAddressSpace()
 * - @ref AttachDeviceAddressSpaceHandle()
 * - @ref GetDeviceAddressSpaceHandle()
 *
 * - @ref MapDeviceAddressSpaceAligned()
 * - @ref UnmapDeviceAddressSpace()
 *
 * - @ref InitializeDeviceAddressSpaceMapInfo()
 * - @ref MapNextDeviceAddressSpaceRegion()
 * - @ref UnmapDeviceAddressSpaceRegion()
 *
 * 上記の関数を利用するには nn/dd.h をインクルードする必要があります。
 */
struct DeviceAddressSpaceType
{
    enum State
    {
        State_NotInitialized        = 0,
        State_Initialized           = 1,
    };

    DeviceAddressSpaceHandle        _deviceHandle;
    uint8_t                         _state;
    bool                            _isHandleManaged;
};

//-----------------------------------------------------------------------------
/**
 * @brief   デバイスアドレス空間にインクリメンタルマップを行なうための情報を保持しておく構造体です
 *
 * @details
 * メンバー変数を直接変更することは禁止です。 @n
 * 次の関数を介して、本構造体を利用してください。
 *
 * - @ref InitializeDeviceAddressSpaceMapInfo()
 * - @ref MapNextDeviceAddressSpaceRegion()
 * - @ref UnmapDeviceAddressSpaceRegion()
 * - @ref GetMappedProcessAddress()
 * - @ref GetMappedDeviceVirtualAddress()
 * - @ref GetMappedSize()
 *
 * 上記の関数を利用するには nn/dd.h をインクルードする必要があります。
 */
struct DeviceAddressSpaceMapInfo
{
    size_t                  _lastMappedSize;
    size_t                  _size;
    uint64_t                _processAddress;
    DeviceVirtualAddress    _deviceStartAddress;
    DeviceVirtualAddress    _deviceEndAddress;
    ProcessHandle           _processHandle;
    MemoryPermission        _devicePermission;
    DeviceAddressSpaceType* _pDeviceAddressSpace;
};

//-----------------------------------------------------------------------------

}}  // namespace nn::dd

