﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief BSD Config Public Data Types
 *
 * @details
 */

#include <nn/socket/socket_Types.h>

namespace nn { namespace bsdsocket { namespace cfg {

enum Limits
{
    Limits_MaxIfNameSize      = 32,
    Limits_MaxSessions        = 4,
    Limits_MaxSessionThreads  = 2,
    Limits_MaxInterfaces      = 2,
};

enum IfIpAddrMode
{
    IfIpAddrMode_Invalid=0,
    IfIpAddrMode_Dhcp,
    IfIpAddrMode_DhcpReboot,
    IfIpAddrMode_Static,
    IfIpAddrMode_Maximum,
};

enum ShutdownOption
{
    ShutdownOption_None = 0,
    ShutdownOption_Release = 1,
    ShutdownOption_Decline = 2,
};

struct IfSettings
{
    IfIpAddrMode mode;
    int32_t     metric;
    uint32_t    mtu;
    nn::socket::InAddr     dnsAddrs[2]; // non-zero for DHCP mode will override
    uint32_t    duplicateIpWaitTime; // time in milliseconds to wait for reply arps to check for duplicate IPs
    bool        isManualDns;
    // Mode specific settings
    union
    {
        struct
        {
            nn::socket::InAddr addr;
            nn::socket::InAddr subnetMask;
            nn::socket::InAddr gatewayAddr;
            nn::socket::InAddr broadcastAddr;
        }modeStatic;
        struct
        {
            int32_t placeholder; // maybe later
        }modeDhcp;
        struct
        {
            nn::socket::InAddr requestedAddr;
            nn::socket::InAddr serverAddr;
        }modeDhcpReboot;
    }u;
};

const IfSettings DefaultIfSettings = {IfIpAddrMode_Invalid, 0, 1500, {{0},{0}}, 1000, false, {{{0},{0},{0},{0}}}};

struct IfState
{
    IfIpAddrMode mode;
    int32_t      metric;
    uint32_t     mtu;
    nn::socket::InAddr      addr;
    nn::socket::InAddr      subnetMask;
    nn::socket::InAddr      gatewayAddr;
    nn::socket::InAddr      broadcastAddr;
    nn::socket::InAddr      dnsAddrs[2];
    nn::socket::InAddr      serverAddr;
    Result       status;

    // Mode specific state
    union
    {
        struct
        {
            uint32_t newLeaseCount;
            uint32_t renewedLeaseCount;
            uint32_t reboundLeaseCount;
            uint32_t invalidLeaseCount;
            char     currentState[32]; // used for debug status
        }modeDhcp;
        struct
        {
            int32_t placeholder; // maybe later
        }modeStatic;
    }u;
};


} // namespace cfg
} // namespace bsdsocket
} // namespace nn






