﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Runtime.Serialization;
using System.Text;

namespace SigloNact.Utilities
{
    [DataContract]
    public class GitRevisionInfo
    {
        [DataMember(Name = nameof(CommitHash))]
        private readonly string _commitHash;
        [DataMember(Name = nameof(BranchName))]
        private readonly string _branchName;
        [DataMember(Name = nameof(CommitCount))]
        private readonly int _commitCount;
        [DataMember(Name = nameof(CommitterDate))]
        private readonly DateTimeOffset _commiterDate;

        public string CommitHash => _commitHash;
        public string BranchName => _branchName;
        public int CommitCount => _commitCount;
        public DateTimeOffset CommitterDate => _commiterDate;

        public GitRevisionInfo(
            string commitHash,
            string branchName,
            int commitCount,
            DateTimeOffset commiterDate)
        {
            this._commitHash = commitHash;
            this._branchName = branchName;
            this._commitCount = commitCount;
            this._commiterDate = commiterDate;
        }
    }
}
