﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.Nact
{
    // App.config の appSettings セクションにアクセスする。
    //
    // appSettings 要素に相対パスで file 属性を与えると、そのファイルが存在すればそのファイルの設定が読み込まれる。
    // Siglo リポジトリに配置したファイルを file 属性に与え、 DDK にはそれを含めないことによって、 DDK で動作を変更することができる。
    //
    // 本設定を濫用しないこと。Siglo 特有の要求に対応するためにのみ、具体的には環境チェックの有効化にのみ使用すること。
    // また、MinSdkCommon では BootedFromSigloRepository は false になることに注意すること。

    internal static class SigloNactAppSettings
    {
        public static bool BootedFromSigloRepository =>
            bool.Parse(GetValue(nameof(BootedFromSigloRepository), "false"));

        private static string GetValue(string key, string defaultValue)
        {
            return System.Configuration.ConfigurationManager.AppSettings.Get(key) ?? defaultValue;
        }
    }
}
