﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Utilities;
using SigloNact.Build;
using System;
using System.Collections.Generic;
using System.Collections.Immutable;
using System.Text;

namespace SigloNact.BuiltIns.ToolChain.Msvc
{
    [NactConstants]
    public sealed class MsvcToolChainParameters : INactObject
    {
        public ImmutableArray<object> NactObjectCreationArguments { get; }

        // enum は Nact 言語側に許された型ではないので公開しない

        public BuildType BuildType { get; }
        public MsvcPlatform Platform { get; }
        public MsvcPlatformToolset PlatformToolset { get; }
        public MsvcConfigurationType ConfigurationType { get; }
        public bool GenerateDebugInfo { get; }
        public bool UseUnicodeCharacterSet { get; }

        [NactObjectCreator]
        public MsvcToolChainParameters(
            string buildType,
            string platform,
            string platformToolset,
            string configurationType,
            bool generateDebugInfo = true,
            bool useUnicodeCharacterSet = true)
        {
            this.NactObjectCreationArguments = ImmutableArray.Create<object>(
                buildType,
                platform,
                platformToolset,
                configurationType,
                generateDebugInfo,
                useUnicodeCharacterSet);

            this.BuildType = Util.ParseEnum<BuildType>(buildType);
            this.Platform = Util.ParseEnum<MsvcPlatform>(platform);
            this.PlatformToolset = Util.ParseEnum<MsvcPlatformToolset>(platformToolset);
            this.ConfigurationType = Util.ParseEnum<MsvcConfigurationType>(configurationType);
            this.GenerateDebugInfo = generateDebugInfo;

            // 以降は本当はコンパイルのみ
            this.UseUnicodeCharacterSet = useUnicodeCharacterSet;
        }
    }
}
