﻿using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text.RegularExpressions;

namespace SigloNact.BuiltIns.ToolChain.Msvc
{
    public static class MsvcHelper
    {
        private static readonly Regex ErrorDetectorRegex = new Regex(": (error|fatal error)");
        private static readonly Regex WarningDetectorRegex = new Regex(": warning");

        public static string MakeProprocessorMacroOption(string macro) =>
            string.Format(CultureInfo.InvariantCulture, "/D\"{0}\"", EscapeDoubleQuotesInPreprocessorMacro(macro));

        public static string EscapeDoubleQuotesInPreprocessorMacro(string macro) =>
            // TODO: AdditionalPreprocessorMacros で二重引用符をエスケープする人がいなくなったら以下のようにして良い。
            // macro.Replace("\"", "\\\"");
            macro.Replace("\\\"", "\"").Replace("\"", "\\\"");

        public static IEnumerable<string> ErrorDetector(IReadOnlyList<string> lines)
        {
            return lines.Where(x => ErrorDetectorRegex.IsMatch(x));
        }

        public static IEnumerable<string> WarningDetector(IReadOnlyList<string> lines)
        {
            return lines.Where(x => WarningDetectorRegex.IsMatch(x));
        }
    }
}
