﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.FileSystem;
using Nintendo.Nact.Utilities;
using SigloNact.Build;
using System;
using System.Collections.Generic;
using System.Collections.Immutable;
using System.Text;

namespace SigloNact.BuiltIns.ToolChain.GccClang
{
    [NactConstants]
    public sealed class GccClangLinkParameters : INactObject
    {
        public ImmutableArray<object> NactObjectCreationArguments { get; }
        public LinkerKind LinkerKind { get; }

        [NactObjectCreator]
        public GccClangLinkParameters(
            string linkerKind)
        {
            this.NactObjectCreationArguments = ImmutableArray.Create<object>(
                linkerKind);

            this.LinkerKind = Util.ParseEnum<LinkerKind>(linkerKind);
        }

        // とりあえずファイル名を返してみる
        internal string LinkerFileName
        {
            get
            {
                switch (LinkerKind)
                {
                    case LinkerKind.Ld:
                        return "ld.exe";
                    case LinkerKind.Gold:
                        return "gold.exe";
                    case LinkerKind.Lld:
                        return "lld.exe";
                    default:
                        throw new InvalidOperationException("should never be reached.");
                }
            }
        }
    }
}
