﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace SigloNact.BuiltIns.Prebuilt
{
    internal static class PrebuiltResultsArchive
    {
        private static Regex LibrariesTargetArchiveRegex = new Regex(@"^Programs\\(.*?)\\Libraries\\(.*?)\\.*$");
        private static Regex ProcessesTargetArchiveRegex = new Regex(@"^Programs\\(.*?)\\Outputs\\(.*?)\\Processes\\.*$");
        private static Regex SystemImagesTargetArchiveRegex = new Regex(@"^Programs\\(.*?)\\Outputs\\(.*?)\\SystemImages\\.*$");
        private static Regex HeadersTargetArchiveRegex = new Regex(@"^Programs\\.*?\\Outputs\\Include\\.*$");
        private static Regex ToolsTargetArchiveRegex = new Regex(@"^Tools\\.*$");

        public static string GetArchiveNameFromResultPath(string resultPath)
        {
            var match = LibrariesTargetArchiveRegex.Match(resultPath);
            if (match.Success)
            {
                return String.Format("PrebuiltResults.{0}.Libraries.{1}", match.Groups[1].Value, match.Groups[2].Value);
            }

            match = ProcessesTargetArchiveRegex.Match(resultPath);
            if (match.Success)
            {
                return String.Format("PrebuiltResults.{0}.Processes.{1}", match.Groups[1].Value, match.Groups[2].Value);
            }

            match = SystemImagesTargetArchiveRegex.Match(resultPath);
            if (match.Success)
            {
                return String.Format("PrebuiltResults.{0}.SystemImages.{1}", match.Groups[1].Value, match.Groups[2].Value);
            }

            match = HeadersTargetArchiveRegex.Match(resultPath);
            if (match.Success)
            {
                return "PrebuiltResults.Headers";
            }

            match = ToolsTargetArchiveRegex.Match(resultPath);
            if (match.Success)
            {
                return "PrebuiltResults.Tools";
            }

            throw new Exception(String.Format("The result '{0}' does not have a appropriate prebuilt's archive.", resultPath));
        }
    }
}
