﻿using Nintendo.Nact.BuiltIn;
using Nintendo.Nact.Execution;
using Nintendo.Nact.FileSystem;
using System;
using System.IO;
using System.IO.Compression;
using System.Threading;

namespace SigloNact.BuiltIns.Prebuilt
{
    [NactActionFunctionContainer]
    public static class ExtractFileFromZipContainer
    {
        [NactActionFunction]
        public static NactActionResult ExtractFileFromZip(
            INactActionContext context,
            FilePath archivePath,
            string entryPath,
            FilePath destinationPath,
            bool forceOverwrite)
        {
            var helper = context.Helper;

            Extract(helper, archivePath, entryPath, destinationPath, forceOverwrite);

            return helper.FinishAsSuccess();
        }

        private static void Extract(INactActionHelper helper, FilePath archivePath, string entryPath, FilePath destinationPath, bool forceOverwrite)
        {
            using (var archiveStream = helper.OpenRead(archivePath))
            using (var archive = new ZipArchive(archiveStream))
            {
                var entryPathTmp = entryPath.Replace('\\', '/');
                var entry = archive.GetEntry(entryPathTmp);

                if (entry == null)
                {
                    throw new Exception(string.Format("指定のアーカイブ {0} には、ファイル {1} は存在しません。", archivePath, entryPath));
                }

                helper.DeleteFile(destinationPath, forceOverwrite);

                using (var entryStream = entry.Open())
                using (var entryReader = new BinaryReader(entryStream))
                using (var destinationStream = helper.CreateFile(destinationPath))
                using (var destinationWriter = new BinaryWriter(destinationStream))
                {
                    var buffer = new byte[1024];

                    while (true)
                    {
                        var length = entryReader.Read(buffer, 0, buffer.Length);

                        if (length == 0)
                        {
                            break;
                        }

                        destinationWriter.Write(buffer, 0, length);
                    }
                }
            }
        }
    }
}
