﻿using Nintendo.Nact.BuiltIn;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SigloNact.BuiltIns.Common
{
    [NactFunctionContainer]
    public static class GetMostlyEqualStringContainer
    {
        [NactFunction]
        public static string GetMostlyEqualString(IEnumerable<string> list, string s)
        {
            return list.Min(t => Tuple.Create(CalculateLevenshteinDistance(s, t), t)).Item2;
        }

        static int CalculateLevenshteinDistance(string s1, string s2)
        {
            const int insertDeleteCost = 10;
            var table = new int[s1.Length + 1, s2.Length + 1];
            for (var i = 0; i <= s1.Length; ++i)
            {
                table[i, 0] = i * insertDeleteCost;
            }
            for (var j = 0; j <= s2.Length; ++j)
            {
                table[0, j] = j * insertDeleteCost;
            }
            for (var i = 0; i < s1.Length; ++i)
            {
                for (var j = 0; j < s2.Length; ++j)
                {
                    var insertValue = table[i, j + 1] + insertDeleteCost;
                    var deleteValue = table[i + 1, j] + insertDeleteCost;
                    var replaceValue = table[i, j] + GetReplaceCost(s1[i], s2[j]);
                    table[i + 1, j + 1] = Math.Min(insertValue, Math.Min(deleteValue, replaceValue));
                }
            }
            return table[s1.Length, s2.Length];
        }

        private static int GetReplaceCost(char c1, char c2)
        {
            if (c1 == c2)
            {
                return 0;
            }
            else if (char.ToLower(c1) == char.ToLower(c2))
            {
                return 1;
            }
            else
            {
                return 10;
            }
        }
    }
}
