﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Build.Construction;

namespace Nintendo.MakeVisualStudioProject.Converter
{
    [Export(typeof(IPlatformElementConverter)), ExportMetadata("SupportedPlatform", "x64")]
    internal class X64PlatformElementConverter : IPlatformElementConverter, IBuiltinOptionDefinitionsAvailable
    {
        private Win32PlatformElementConverter m_Win32Generator;

        public bool UseBuiltinOptionDefinitions
        {
            get
            {
                return m_Win32Generator.UseBuiltinOptionDefinitions;
            }
            set
            {
                m_Win32Generator.UseBuiltinOptionDefinitions = value;
            }
        }

        public X64PlatformElementConverter()
        {
            m_Win32Generator = new Win32PlatformElementConverter();
        }

        public void SetProjectPathInfo(string projectDirectory, IDictionary<string, string> substitutionPaths)
        {
            ((IPlatformElementConverter)m_Win32Generator).SetProjectPathInfo(projectDirectory, substitutionPaths);
        }

        public bool AcceptsBuildTargetSetting(BuildTargetSetting targetSetting)
        {
            return targetSetting.Platform == "x64";
        }

        public void AddCompileOptionMetadatas(ProjectItemElement clCompile, IEnumerable<string> compileOptions, BuildTargetSetting targetSetting)
        {
            m_Win32Generator.AddCompileOptionMetadatas(clCompile, compileOptions, targetSetting);
        }

        public IEnumerable<string> ReadCompileOptionMetadatas(ProjectItemElement clCompile, BuildTargetSetting targetSetting)
        {
            return m_Win32Generator.ReadCompileOptionMetadatas(clCompile, targetSetting);
        }

        public void AddCustomProperties(ProjectPropertyGroupElement propertyGroup, BuildTargetSetting targetSetting)
        {
            m_Win32Generator.AddCustomProperties(propertyGroup, targetSetting);
        }

        public void ReadCustomProperties(ProjectPropertyGroupElement propertyGroup, BuildTargetSetting targetSetting)
        {
            m_Win32Generator.ReadCustomProperties(propertyGroup, targetSetting);
        }

        public void AddCustomItemDefinitions(ProjectItemDefinitionGroupElement itemDefinitionGroup, VcProjectConfigurationType type, BuildTargetSetting targetSetting)
        {
            m_Win32Generator.AddCustomItemDefinitions(itemDefinitionGroup, type, targetSetting);
        }

        public void ReadCustomItemDefinitions(ProjectItemDefinitionGroupElement itemDefinitionGroup, VcProjectConfigurationType type, BuildTargetSetting targetSetting)
        {
            m_Win32Generator.ReadCustomItemDefinitions(itemDefinitionGroup, type, targetSetting);
        }
    }
}
