﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakeVisualStudioProject.Converter
{
    internal class Win32OptionConverter : OptionConverter
    {
        public static Win32OptionConverter GetClOptionConverter(string vcToolsVersion, string vsVersion)
        {
            return new Win32OptionConverter(Win32OptionDefinitionGenerator.GetClOptionDefinitions(vcToolsVersion, vsVersion));
        }

        public static Win32OptionConverter GetClangC2OptionConverter(string vcToolsVersion, string vsVersion)
        {
            return new Win32OptionConverter(Win32OptionDefinitionGenerator.GetClangC2OptionDefinitions(vcToolsVersion, vsVersion));
        }

        public static Win32OptionConverter GetLibOptionConverter(string vcToolsVersion, string vsVersion)
        {
            return new Win32OptionConverter(Win32OptionDefinitionGenerator.GetLibOptionDefinitions(vcToolsVersion, vsVersion));
        }

        public static Win32OptionConverter GetLinkOptionConverter(string vcToolsVersion, string vsVersion)
        {
            return new Win32OptionConverter(Win32OptionDefinitionGenerator.GetLinkOptionDefinitions(vcToolsVersion, vsVersion));
        }

        private Win32OptionConverter(IEnumerable<OptionDefinition> ods)
        {
            this.OptionStringConverter = new Win32OptionStringConverter(ods);
            this.ItemMetadataConverter = new Win32ItemMetadataConverter(ods);
        }

        private static string CreateBuiltInOptionDefinitionYamlFileResourceName(string toolName, string vcToolsVersion)
        {
            switch (vcToolsVersion)
            {
                case "4.0":
                    return $"Nintendo.MakeVisualStudioProject.BuiltInOptionDefinition.{toolName}.v110.yml";
                case "12.0":
                    return $"Nintendo.MakeVisualStudioProject.BuiltInOptionDefinition.{toolName}.v120.yml";
                case "14.0":
                    return $"Nintendo.MakeVisualStudioProject.BuiltInOptionDefinition.{toolName}.v140.yml";
                case "15.0":
                    return $"Nintendo.MakeVisualStudioProject.BuiltInOptionDefinition.{toolName}.v141.yml";
                default:
                    throw new ConversionException($"無効な ToolsVersion です: {vcToolsVersion}");
            }
        }
        public static Win32OptionConverter GetBuiltinClOptionConverter(string vcToolsVersion = "4.0")
        {
            var resourceName = CreateBuiltInOptionDefinitionYamlFileResourceName("cl", vcToolsVersion);
            using (var stream = Assembly.GetExecutingAssembly().GetManifestResourceStream(resourceName))
            {
                if (stream == null)
                {
                    throw new ConversionException(string.Format("Visual Studio バージョン '{0}' に対応する cl.exe オプション定義は組み込まれていません。", vcToolsVersion));
                }
                using (var reader = new StreamReader(stream))
                {
                    return new Win32OptionConverter(OptionDefinitionGenerator.LoadDefinitions(reader));
                }
            }
        }
        public static Win32OptionConverter GetBuiltinClangC2OptionConverter(string vcToolsVersion = "4.0")
        {
            var resourceName = CreateBuiltInOptionDefinitionYamlFileResourceName("clang", vcToolsVersion);
            using (var stream = Assembly.GetExecutingAssembly().GetManifestResourceStream(resourceName))
            {
                if (stream == null)
                {
                    throw new ConversionException(string.Format("Visual Studio バージョン '{0}' に対応する clang.exe オプション定義は組み込まれていません。", vcToolsVersion));
                }
                using (var reader = new StreamReader(stream))
                {
                    return new Win32OptionConverter(OptionDefinitionGenerator.LoadDefinitions(reader));
                }
            }
        }
        public static Win32OptionConverter GetBuiltinLibOptionConverter(string vcToolsVersion = "4.0")
        {
            var resourceName = CreateBuiltInOptionDefinitionYamlFileResourceName("lib", vcToolsVersion);
            using (var stream = Assembly.GetExecutingAssembly().GetManifestResourceStream(resourceName))
            {
                if (stream == null)
                {
                    throw new ConversionException(string.Format("Visual Studio バージョン '{0}' に対応する lib.exe オプション定義は組み込まれていません。", vcToolsVersion));
                }
                using (var reader = new StreamReader(stream))
                {
                    return new Win32OptionConverter(OptionDefinitionGenerator.LoadDefinitions(reader));
                }
            }
        }
        public static Win32OptionConverter GetBuiltinLinkOptionConverter(string vcToolsVersion = "4.0")
        {
            var resourceName = CreateBuiltInOptionDefinitionYamlFileResourceName("link", vcToolsVersion);
            using (var stream = Assembly.GetExecutingAssembly().GetManifestResourceStream(resourceName))
            {
                if (stream == null)
                {
                    throw new ConversionException(string.Format("Visual Studio バージョン '{0}' に対応する link.exe オプション定義は組み込まれていません。", vcToolsVersion));
                }
                using (var reader = new StreamReader(stream))
                {
                    return new Win32OptionConverter(OptionDefinitionGenerator.LoadDefinitions(reader));
                }
            }
        }
    }
}
