﻿using System;
using System.Collections.Generic;
using System.IO;
using Nintendo.MakeVisualStudioProject.Converter;

var generationConfigurations = new (string yamlFileNameWithoutExtension, Func<IEnumerable<OptionDefinition>> optionDefinitionFactory)[]
{
    ("cl.v140", () => Win32OptionDefinitionGenerator.GetClOptionDefinitions("14.0", "140")),
    ("lib.v140", () => Win32OptionDefinitionGenerator.GetLibOptionDefinitions("14.0", "140")),
    ("link.v140", () => Win32OptionDefinitionGenerator.GetLinkOptionDefinitions("14.0", "140")),
    ("cl.v141", () => Win32OptionDefinitionGenerator.GetClOptionDefinitions("15.0", "150")),
    ("lib.v141", () => Win32OptionDefinitionGenerator.GetLibOptionDefinitions("15.0", "150")),
    ("link.v141", () => Win32OptionDefinitionGenerator.GetLinkOptionDefinitions("15.0", "150")),
};

foreach (var generationConfiguration in generationConfigurations)
{
    var optionDefinitions = generationConfiguration.optionDefinitionFactory();
    var yamlFileName = generationConfiguration.yamlFileNameWithoutExtension + ".yml";

    using (var writer = new StreamWriter(yamlFileName))
    {
        OptionDefinitionGenerator.SaveDefinitions(writer, optionDefinitions);
    }
}
