﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Build.Construction;

namespace Nintendo.MakePropertySheets
{
    public static class ProjectRootElementExtension
    {
        public static ProjectPropertyGroupElement AddPropertyGroup(this ProjectRootElement This, string condition)
        {
            var propertyGroup = This.AddPropertyGroup();
            if (condition != null)
            {
                propertyGroup.Condition = condition;
            }
            return propertyGroup;
        }

        public static ProjectItemDefinitionGroupElement AddItemDefinitionGroup(this ProjectRootElement This, string condition)
        {
            var itemDefinitionGroup = This.AddItemDefinitionGroup();
            if (condition != null)
            {
                itemDefinitionGroup.Condition = condition;
            }
            return itemDefinitionGroup;
        }

        public static ProjectImportElement CreateImportElement(this ProjectRootElement This, string project, string condition)
        {
            var import = This.CreateImportElement(project);
            if (condition != null)
            {
                import.Condition = condition;
            }
            return import;
        }
    }

    public static class ProjectPropertyGroupElementExtension
    {
        public static ProjectPropertyElement AddProperty(this ProjectPropertyGroupElement This, string name, string unevaluatedValue, string condition)
        {
            var property = This.AddProperty(name, unevaluatedValue);
            if (condition != null)
            {
                property.Condition = condition;
            }
            return property;
        }
    }

    public static class ProjectItemDefinitionElementExtension
    {
        public static ProjectMetadataElement AddMetadata(this ProjectItemDefinitionElement This, string name, string unevaluatedValue, string condition)
        {
            var metadata = This.AddMetadata(name, unevaluatedValue);
            if (condition != null)
            {
                metadata.Condition = condition;
            }
            return metadata;
        }
    }

    public static class ProjectItemDefinitionGroupElementExtension
    {
        public static ProjectItemDefinitionElement AddItemDefinition(this ProjectItemDefinitionGroupElement This, string itemType, string condition)
        {
            var itemDefinition = This.AddItemDefinition(itemType);
            if (condition != null)
            {
                itemDefinition.Condition = condition;
            }
            return itemDefinition;
        }
    }
}
