﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Target
{
    public class ProjectTarget : ProjectElement
    {
        public string Name { get; }
        public string BeforeTargets { get; }
        public string AfterTargets { get; }
        public IEnumerable<ProjectTask> Tasks { get; }

        public ProjectTarget(string name, params ProjectTask[] tasks) : this(name, string.Empty, string.Empty, string.Empty, tasks)
        {
        }
        public ProjectTarget(string name, string condition, params ProjectTask[] tasks) : this(name, condition, string.Empty, string.Empty, tasks)
        {
        }
        public ProjectTarget(string name, string condition, string beforeTargets, string afterTargets, params ProjectTask[] tasks) : base(condition)
        {
            Name = name;
            BeforeTargets = beforeTargets ?? string.Empty;
            AfterTargets = afterTargets ?? string.Empty;
            Tasks = tasks;
        }
    }
}
