﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NXToolchainDir : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            switch (ctx.Intent.BuildEnvironment)
            {
                case Constants.BuildEnvironment.Repository:
                    yield return new ProjectPropertyGroup(Constants.Condition.PlatformNX32OrNX64,
                        new ProjectProperty("NXToolchainDir", @"$(RYNDA_ROOT)\clang-for-nx.$(NXToolchainVersion)",
                            "'$(RYNDA_ROOT)'!=''"),
                        new ProjectProperty("NXToolchainDir", @"$(SIGLO_TOOLCHAINS_ROOT)\clang-for-nx.$(NXToolchainVersion)",
                            "'$(RYNDA_ROOT)'=='' and '$(SIGLO_TOOLCHAINS_ROOT)'!=''"),
                        new ProjectProperty("NXToolchainDir", @"$(NintendoSdkRoot)\ToolChains\clang-for-nx.$(NXToolchainVersion)",
                            "'$(RYNDA_ROOT)'=='' and '$(SIGLO_TOOLCHAINS_ROOT)'==''"));
                    break;
                case Constants.BuildEnvironment.Package:
                    yield return new ProjectPropertyGroup(Constants.Condition.PlatformNX32OrNX64,
                        new ProjectProperty("NXToolchainDir", @"$(NintendoSdkRoot)\Compilers\NX"));
                    break;
                default:
                    ReportUnexpectedBuildEnvironment(ctx);
                    break;
            }
        }
    }
}
