﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class MainRuntimeObjectName : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            // メモ: 新方式のリンカオプション生成器を使用できる場合は %(Link.SdkRuntimeDependencies) に含まれるので不要
            //       使用できない場合 (SDK は新しいが Oasis が古い場合) は依然として $(MainRuntimeObjectName) が必要
            //       新方式を使用できるのは Oasis 4.3 からなので、Oasis 4.2 (を含む SDK) のサポートが終了したら削除可能？
            yield return new ProjectPropertyGroup(Constants.Condition.PlatformNX32OrNX64,
                new ProjectProperty("MainRuntimeObjectName", "nn$(_NintendoSdkProgramKind).o"));
        }
    }
}
