﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class AdditionalLibraryDirectories : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.Cafe)
            {
                yield break;
            }

            yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformCafe,
                new ProjectMetadata("AdditionalLibraryDirectories",
                    @"$(NintendoSdkLibraryPath);$(CAFE_ROOT)\system\lib\ghs\cafe\DEBUG;%(AdditionalLibraryDirectories)", Constants.Condition.NintendoSdkBuildTypeDebug),
                new ProjectMetadata("AdditionalLibraryDirectories",
                    @"$(NintendoSdkLibraryPath);$(CAFE_ROOT)\system\lib\ghs\cafe\NDEBUG;%(AdditionalLibraryDirectories)", Constants.Condition.NintendoSdkBuildTypeDevelopOrRelease));
        }
    }
}
