﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.ClCompile
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class OmitFramePointer : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            yield return new ProjectItemDefinition("ClCompile", Constants.Condition.PlatformNX32OrNX64,
                new ProjectMetadata("OmitFramePointer", "false", Constants.Condition.NintendoSdkBuildTypeDebugOrDevelop),
                new ProjectMetadata("OmitFramePointer", "true", Constants.Condition.NintendoSdkBuildTypeRelease));
        }
    }
}
