﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <git2.h>

// 警告 LNK:4248 を抑制するためのダミー定義です。
// 本当の定義は libgit2 の include 外ソースヘッダに含まれています。
struct git_config
{};
struct git_index
{};
struct git_object
{};
struct git_blob
{};
struct git_tree
{};
struct git_tree_entry
{};
struct git_repository
{};

namespace Libgit2 {

    template <typename T>
    class HandleHolder
    {
    public:
        HandleHolder() : m_pHandle(0) {}
        virtual ~HandleHolder(){}

        T* GetHandle()
        {
            return m_pHandle;
        }

        T** GetPointer()
        {
            return &m_pHandle;
        }

    protected:
        virtual void Free(T* handle) = 0;

    private:
        T* m_pHandle;
    };

    class RepositoryHolder : public HandleHolder<git_repository>
    {
    public:
        virtual ~RepositoryHolder()
        {
            if(this->GetHandle() != NULL)
            {
                Free(this->GetHandle());
            }
        }

    protected:
        virtual void Free(git_repository* handle)
        {
            git_repository_free(handle);
        }
    };

    class ConfigHolder : public HandleHolder<git_config>
    {
    public:
        virtual ~ConfigHolder()
        {
            if(this->GetHandle() != NULL)
            {
                Free(this->GetHandle());
            }
        }

    protected:
        virtual void Free(git_config* handle)
        {
            git_config_free(handle);
        }
    };

    class IndexHolder : public HandleHolder<git_index>
    {
    public:
        virtual ~IndexHolder()
        {
            if(this->GetHandle() != NULL)
            {
                Free(this->GetHandle());
            }
        }

    protected:
        virtual void Free(git_index* handle)
        {
            git_index_free(handle);
        }
    };

    class ObjectHolder : public HandleHolder<git_object>
    {
    public:
        virtual ~ObjectHolder()
        {
            if(this->GetHandle() != NULL)
            {
                Free(this->GetHandle());
            }
        }

    protected:
        virtual void Free(git_object* handle)
        {
            git_object_free(handle);
        }
    };
}
