﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace Libgit2 {

    public ref class ExpandSmudgeFilter abstract
    {
    public:
        static void Init(const char* cacheDirectoryPath);
        static void Shutdown();

        static void Register();
        static void Unregister();

        static void ResetNumberOfRunningCacheDownloadThreads(int n);
        static int GetNumberOfRunningCacheDownloadThreads();
        static void DecrementNumberOfRunningCacheDownloadThreads();

    private:
        static int g_NumberOfRunningCacheDownloadThreads;
        static System::Threading::Mutex^ g_MutexForNumberOfRunningCacheDownloadThreads;
    };

}
