﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalStorage
{
    public class Program
    {
        public static void Main(string[] args)
        {
            Initialize();

            if (args.Count() < 1)
            {
                Console.WriteLine("usage: GitExternalStorage.exe [ install | status | upload | expand | sync | clear | filter-clean | filter-smudge | assume-unchanged | no-assume-unchanged ]");
                Console.WriteLine("");
                Console.WriteLine("Please see the following page for more details.");
                Console.WriteLine("http://spdlybra.nintendo.co.jp/confluence/pages/viewpage.action?pageId=53058457");
                return;
            }

#if DEBUG
            DoCommand(args);
#else
            try
            {
                DoCommand(args);
            }
            catch (GitExternalStorageException e)
            {
                StringBuilder detailBuilder = new StringBuilder();
                for (Exception exception = e; exception != null; exception = exception.InnerException)
                {
                    if (exception.Data.Contains("Detail"))
                    {
                        detailBuilder.Append(exception.Data["Detail"]);
                    }
                }
                Console.Error.WriteLine("Error : {0}", e.Message + detailBuilder.ToString());

                Environment.Exit(1);
            }
            catch (Exception e)
            {
                StringBuilder detailBuilder = new StringBuilder();
                for (Exception exception = e; exception != null; exception = exception.InnerException)
                {
                    if (exception.Data.Contains("Detail"))
                    {
                        detailBuilder.Append(exception.Data["Detail"]);
                    }
                }

                Console.Error.WriteLine("Internal error : {0}", e.Message + detailBuilder.ToString());
                Console.Error.WriteLine(string.Empty);
                Console.Error.WriteLine("== Exception ==");
                Console.Error.WriteLine(string.Empty);
                Console.Error.WriteLine(e.ToString());

                Environment.Exit(1);
            }
#endif
        }

        public static void Initialize()
        {
            // TODO: TortoiseGit を使用するとき、この処理で例外が発生するため、コメントアウト
            //Console.OutputEncoding = Encoding.UTF8;
        }

        public static void DoCommand(string[] args)
        {
            var command = args[0];

            switch (command)
            {
                case "install-filter":
                    new Commands.InstallFilterCommand().Run();
                    break;
                case "install-hooks":
                    new Commands.InstallHookScriptCommand().Run();
                    break;
                case "filter-clean":
                    new Commands.FilterCleanCommand().Run();
                    break;
                case "filter-smudge":
                    new Commands.FilterSmudgeCommand().Run();
                    break;
                case "status":
                    new Commands.StatusCommand().Run();
                    break;
                case "sync":
                    new Commands.SyncCommand().Run();
                    break;
                case "clear":
                    new Commands.ClearCommand().Run();
                    break;
                case "upload":
                    new Commands.UploadCommand().Run();
                    break;
                case "expand":
                    new Commands.ExpandCommand().Run();
                    break;
                case "assume-unchanged":
                    new Commands.AssumeUnchangedCommand().Run();
                    break;
                case "no-assume-unchanged":
                    new Commands.NoAssumeUnchangedCommand().Run();
                    break;
                default:
                    throw new GitExternalStorageException(string.Format("'{0}' is invalid argument.", command));
            }
        }
    }
}
