﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalStorage.Git
{
    /// <summary>
    /// git コマンドが見つからない場合に発生する例外です。
    /// </summary>
    public class GitRepositoryCommandNotFoundException : Exception
    {
        public GitRepositoryCommandNotFoundException()
            : base()
        {
        }

        public GitRepositoryCommandNotFoundException(string message)
            : base(message)
        {
        }

        protected GitRepositoryCommandNotFoundException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }

        public GitRepositoryCommandNotFoundException(string message, Exception innerException)
            : base(message, innerException)
        {
        }
    }
}
