﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalStorage.Core
{
    /// <summary>
    /// ハッシュ化したファイルの情報を表します。
    /// </summary>
    public class ReferenceEntry
    {
        public string FilePath { get; set; }
        public int FileSize { get; set; }
        public string Sha { get; set; }
    }

    /// <summary>
    /// ハッシュ化したファイルの参照状態を表します。
    /// </summary>
    public class ReferenceInfo
    {
        public List<ReferenceEntry> All { get; set; }
        public List<ReferenceEntry> ToExpand { get; set; }
        public List<ReferenceEntry> Expanded { get; set; }
        public List<ReferenceEntry> Deleted { get; set; }
    }
}
